CREATE TABLE change_record(
	uuid char(255) NOT NULL UNIQUE,
	type int NOT NULL,
	table_name char(255) NOT NULL,
	primary_key char(255) NOT NULL,
	time_stamp datetime NOT NULL,
	fields char(4096) NOT NULL
);

CREATE INDEX change_record_primary_key_index ON change_record (primary_key);
CREATE INDEX change_record_type_index ON change_record (type);
CREATE INDEX change_record_table_name ON change_record (table_name);

CREATE TABLE change_set_config(
	uuid char(255) NOT NULL UNIQUE,
	parent_id char(255),
	server_id char(255) NOT NULL,
	client_id char(255) NOT NULL,
	version int NOT NULL,
	create_date double NOT NULL,
	modify_date double NOT NULL
);

CREATE TABLE user_info (
    key char(255) NOT NULL UNIQUE,
    value char(255)
);

CREATE INDEX user_info_key ON user_info (key);
